
// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float iPro = (3.0f* progress * progress - 2.0f * progress * progress * progress); 	
	float4 outputCol;

	float4 y1 = INPUT(input1, param, uv);
	float4 y2 = (vec4)(0.0f);
	const int iColWidth = 5; 
	const int iColDouble = iColWidth * 2;

	float leftMattOffset = iPro*2.0f+ 0.5f*cos(uv.y*PI + PI)-0.5f;
	float leftMatt = step( (float)(gl_FragCoord.y% iColDouble), (float)(iColWidth))* step( uv.x, leftMattOffset); 
	
	float rightMattOffset = (1.0f - iPro)*2.0f - 0.5f*cos(uv.y*PI + PI)-0.5f; 
	float rightMatt = step( (float)(iColWidth+1), (float)(gl_FragCoord.y % iColDouble))* step(rightMattOffset, uv.x);
	//outputCol = mix(y1, y2, clamp( (leftMatt+rightMatt)+(step(1.0f - uv.y, iPro)),0.0f, 1.0f) ); 
	
	if(gl_FragCoord.y% iColDouble < iColWidth)
	{
		y2 = INPUT( input2, param, uv - (vec2)( clamp( leftMattOffset -1.0f,-10.0f, 0.0f), 0.0f ) );
	}else
	{
		y2 = INPUT(input2, param, uv - (vec2)(clamp(rightMattOffset,0.0f,10.0f),0.0f) );
	}
	outputCol = mix(y1, y2, clamp( leftMatt + rightMatt ,0.0f, 1.0f) ); 
	write_imagef(dstImg, (int2)(w, textH - h -1), outputCol);
}
